%------------------------------------------------------------------------------
% File     : LCL948^10 : TPTP v9.2.0. Released v8.1.0.
% Domain   : Logic Calculi
% Problem  : Goedel translation of SET002+4 (from TPTP-v5.0.0)
% Version  : [BP13] axioms.
% English  : 

% Refs     : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
%          : [BP13]  Benzmueller & Paulson (2013), Quantified Multimodal Lo
%          : [Ste22] Steen (2022), An Extensible Logic Embedding Tool for L
% Source   : [TPTP]
% Names    : GSE002+4 [QMLTP]

% Status   : CounterSatisfiable 
% Rating   : 1.00 v9.0.0, 0.75 v8.2.0, 1.00 v8.1.0
% Syntax   : Number of formulae    :   73 (  12 unt;  27 typ;  10 def)
%            Number of atoms       :  571 (  10 equ;   0 cnn)
%            Maximal formula atoms :   30 (  12 avg)
%            Number of connectives :  832 (   1   ~;   1   |;   4   &; 821   @)
%                                         (   1 <=>;   4  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   21 (  13 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :   83 (  83   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   27 (  26 usr;   2 con; 0-3 aty)
%            Number of variables   :  121 ( 111   ^;   7   !;   3   ?; 121   :)
% SPC      : TH0_CSA_EQU_NAR

% Comments : This output was generated by embedproblem, version 1.7.1 (library
%            version 1.3). Generated on Thu Apr 28 13:18:18 EDT 2022 using
%            'modal' embedding, version 1.5.2. Logic specification used:
%            $modal == [$constants == $rigid,$quantification == $varying,
%            $modalities == $modal_system_S4].
%------------------------------------------------------------------------------
thf(mworld,type,
    mworld: $tType ).

thf(mrel_type,type,
    mrel: mworld > mworld > $o ).

thf(mactual_type,type,
    mactual: mworld ).

thf(mlocal_type,type,
    mlocal: ( mworld > $o ) > $o ).

thf(mlocal_def,definition,
    ( mlocal
    = ( ^ [Phi: mworld > $o] : ( Phi @ mactual ) ) ) ).

thf(mnot_type,type,
    mnot: ( mworld > $o ) > mworld > $o ).

thf(mand_type,type,
    mand: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mor_type,type,
    mor: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mimplies_type,type,
    mimplies: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mequiv_type,type,
    mequiv: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mnot_def,definition,
    ( mnot
    = ( ^ [A: mworld > $o,W: mworld] :
          ~ ( A @ W ) ) ) ).

thf(mand_def,definition,
    ( mand
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          & ( B @ W ) ) ) ) ).

thf(mor_def,definition,
    ( mor
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          | ( B @ W ) ) ) ) ).

thf(mimplies_def,definition,
    ( mimplies
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
         => ( B @ W ) ) ) ) ).

thf(mequiv_def,definition,
    ( mequiv
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
        <=> ( B @ W ) ) ) ) ).

thf(mbox_type,type,
    mbox: ( mworld > $o ) > mworld > $o ).

thf(mbox_def,definition,
    ( mbox
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ! [V: mworld] :
          ( ( mrel @ W @ V )
         => ( Phi @ V ) ) ) ) ).

thf(mdia_type,type,
    mdia: ( mworld > $o ) > mworld > $o ).

thf(mdia_def,definition,
    ( mdia
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ? [V: mworld] :
          ( ( mrel @ W @ V )
          & ( Phi @ V ) ) ) ) ).

thf(mrel_reflexive,axiom,
    ! [W: mworld] : ( mrel @ W @ W ) ).

thf(mrel_transitive,axiom,
    ! [W: mworld,V: mworld,U: mworld] :
      ( ( ( mrel @ W @ V )
        & ( mrel @ V @ U ) )
     => ( mrel @ W @ U ) ) ).

thf(eiw_di_type,type,
    eiw_di: $i > mworld > $o ).

thf(eiw_di_nonempty,axiom,
    ! [W: mworld] :
    ? [X: $i] : ( eiw_di @ X @ W ) ).

thf(mforall_di_type,type,
    mforall_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mforall_di_def,definition,
    ( mforall_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ! [X: $i] :
          ( ( eiw_di @ X @ W )
         => ( A @ X @ W ) ) ) ) ).

thf(mexists_di_type,type,
    mexists_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mexists_di_def,definition,
    ( mexists_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ? [X: $i] :
          ( ( eiw_di @ X @ W )
          & ( A @ X @ W ) ) ) ) ).

thf(empty_set_decl,type,
    empty_set: $i ).

thf(qmltpeq_decl,type,
    qmltpeq: $i > $i > mworld > $o ).

thf(equal_set_decl,type,
    equal_set: $i > $i > mworld > $o ).

thf(member_decl,type,
    member: $i > $i > mworld > $o ).

thf(subset_decl,type,
    subset: $i > $i > mworld > $o ).

thf(singleton_decl,type,
    singleton: $i > $i ).

thf(product_decl,type,
    product: $i > $i ).

thf(unordered_pair_decl,type,
    unordered_pair: $i > $i > $i ).

thf(intersection_decl,type,
    intersection: $i > $i > $i ).

thf(difference_decl,type,
    difference: $i > $i > $i ).

thf(sum_decl,type,
    sum: $i > $i ).

thf(union_decl,type,
    union: $i > $i > $i ).

thf(power_set_decl,type,
    power_set: $i > $i ).

thf(reflexivity,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( qmltpeq @ X @ X ) ) ) ) ) ).

thf(symmetry,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ X @ Y ) ) @ ( mbox @ ( qmltpeq @ Y @ X ) ) ) ) ) ) ) ) ) ).

thf(transitivity,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Z: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ X @ Y ) ) @ ( mbox @ ( qmltpeq @ Y @ Z ) ) ) @ ( mbox @ ( qmltpeq @ X @ Z ) ) ) ) ) ) ) ) ) ) ) ).

thf(difference_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( difference @ A @ C ) @ ( difference @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(difference_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( difference @ C @ A ) @ ( difference @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(intersection_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( intersection @ A @ C ) @ ( intersection @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(intersection_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( intersection @ C @ A ) @ ( intersection @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(power_set_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( power_set @ A ) @ ( power_set @ B ) ) ) ) ) ) ) ) ) ) ).

thf(product_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( product @ A ) @ ( product @ B ) ) ) ) ) ) ) ) ) ) ).

thf(singleton_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( singleton @ A ) @ ( singleton @ B ) ) ) ) ) ) ) ) ) ) ).

thf(sum_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( sum @ A ) @ ( sum @ B ) ) ) ) ) ) ) ) ) ) ).

thf(union_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( union @ A @ C ) @ ( union @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(union_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( union @ C @ A ) @ ( union @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(unordered_pair_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( unordered_pair @ A @ C ) @ ( unordered_pair @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(unordered_pair_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( unordered_pair @ C @ A ) @ ( unordered_pair @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(equal_set_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( equal_set @ A @ C ) ) ) @ ( mbox @ ( equal_set @ B @ C ) ) ) ) ) ) ) ) ) ) ) ).

thf(equal_set_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( equal_set @ C @ A ) ) ) @ ( mbox @ ( equal_set @ C @ B ) ) ) ) ) ) ) ) ) ) ) ).

thf(member_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( member @ A @ C ) ) ) @ ( mbox @ ( member @ B @ C ) ) ) ) ) ) ) ) ) ) ) ).

thf(member_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( member @ C @ A ) ) ) @ ( mbox @ ( member @ C @ B ) ) ) ) ) ) ) ) ) ) ) ).

thf(subset_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( subset @ A @ C ) ) ) @ ( mbox @ ( subset @ B @ C ) ) ) ) ) ) ) ) ) ) ) ).

thf(subset_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( subset @ C @ A ) ) ) @ ( mbox @ ( subset @ C @ B ) ) ) ) ) ) ) ) ) ) ) ).

thf(subset_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mand
                  @ ( mbox
                    @ ( mimplies @ ( mbox @ ( subset @ A @ B ) )
                      @ ( mbox
                        @ ( mforall_di
                          @ ^ [X: $i] : ( mbox @ ( mimplies @ ( mbox @ ( member @ X @ A ) ) @ ( mbox @ ( member @ X @ B ) ) ) ) ) ) ) )
                  @ ( mbox
                    @ ( mimplies
                      @ ( mbox
                        @ ( mforall_di
                          @ ^ [X: $i] : ( mbox @ ( mimplies @ ( mbox @ ( member @ X @ A ) ) @ ( mbox @ ( member @ X @ B ) ) ) ) ) )
                      @ ( mbox @ ( subset @ A @ B ) ) ) ) ) ) ) ) ) ) ).

thf(equal_set_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( equal_set @ A @ B ) ) @ ( mand @ ( mbox @ ( subset @ A @ B ) ) @ ( mbox @ ( subset @ B @ A ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( subset @ A @ B ) ) @ ( mbox @ ( subset @ B @ A ) ) ) @ ( mbox @ ( equal_set @ A @ B ) ) ) ) ) ) ) ) ) ) ).

thf(power_set_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [A: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ X @ ( power_set @ A ) ) ) @ ( mbox @ ( subset @ X @ A ) ) ) ) @ ( mbox @ ( mimplies @ ( mbox @ ( subset @ X @ A ) ) @ ( mbox @ ( member @ X @ ( power_set @ A ) ) ) ) ) ) ) ) ) ) ) ).

thf(intersection_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [A: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [B: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ X @ ( intersection @ A @ B ) ) ) @ ( mand @ ( mbox @ ( member @ X @ A ) ) @ ( mbox @ ( member @ X @ B ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ X @ A ) ) @ ( mbox @ ( member @ X @ B ) ) ) @ ( mbox @ ( member @ X @ ( intersection @ A @ B ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(union_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [A: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [B: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ X @ ( union @ A @ B ) ) ) @ ( mor @ ( mbox @ ( member @ X @ A ) ) @ ( mbox @ ( member @ X @ B ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mor @ ( mbox @ ( member @ X @ A ) ) @ ( mbox @ ( member @ X @ B ) ) ) @ ( mbox @ ( member @ X @ ( union @ A @ B ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(empty_set_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( mnot @ ( mbox @ ( member @ X @ empty_set ) ) ) ) ) ) ) ).

thf(difference_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [B: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [A: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [E: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ B @ ( difference @ E @ A ) ) ) @ ( mand @ ( mbox @ ( member @ B @ E ) ) @ ( mbox @ ( mnot @ ( mbox @ ( member @ B @ A ) ) ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ B @ E ) ) @ ( mbox @ ( mnot @ ( mbox @ ( member @ B @ A ) ) ) ) ) @ ( mbox @ ( member @ B @ ( difference @ E @ A ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(singleton_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [A: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ X @ ( singleton @ A ) ) ) @ ( mbox @ ( qmltpeq @ X @ A ) ) ) ) @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ X @ A ) ) @ ( mbox @ ( member @ X @ ( singleton @ A ) ) ) ) ) ) ) ) ) ) ) ).

thf(unordered_pair_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [A: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [B: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ X @ ( unordered_pair @ A @ B ) ) ) @ ( mor @ ( mbox @ ( qmltpeq @ X @ A ) ) @ ( mbox @ ( qmltpeq @ X @ B ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mor @ ( mbox @ ( qmltpeq @ X @ A ) ) @ ( mbox @ ( qmltpeq @ X @ B ) ) ) @ ( mbox @ ( member @ X @ ( unordered_pair @ A @ B ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(sum_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [A: $i] :
                  ( mand
                  @ ( mbox
                    @ ( mimplies @ ( mbox @ ( member @ X @ ( sum @ A ) ) )
                      @ ( mexists_di
                        @ ^ [Y: $i] : ( mand @ ( mbox @ ( member @ Y @ A ) ) @ ( mbox @ ( member @ X @ Y ) ) ) ) ) )
                  @ ( mbox
                    @ ( mimplies
                      @ ( mexists_di
                        @ ^ [Y: $i] : ( mand @ ( mbox @ ( member @ Y @ A ) ) @ ( mbox @ ( member @ X @ Y ) ) ) )
                      @ ( mbox @ ( member @ X @ ( sum @ A ) ) ) ) ) ) ) ) ) ) ) ).

thf(product_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [A: $i] :
                  ( mand
                  @ ( mbox
                    @ ( mimplies @ ( mbox @ ( member @ X @ ( product @ A ) ) )
                      @ ( mbox
                        @ ( mforall_di
                          @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( member @ Y @ A ) ) @ ( mbox @ ( member @ X @ Y ) ) ) ) ) ) ) )
                  @ ( mbox
                    @ ( mimplies
                      @ ( mbox
                        @ ( mforall_di
                          @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( member @ Y @ A ) ) @ ( mbox @ ( member @ X @ Y ) ) ) ) ) )
                      @ ( mbox @ ( member @ X @ ( product @ A ) ) ) ) ) ) ) ) ) ) ) ).

thf(thI14,conjecture,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] : ( mbox @ ( equal_set @ ( union @ A @ A ) @ A ) ) ) ) ) ).

%------------------------------------------------------------------------------
